<?php
/**
 * Premium shop view;
 * @author OlegKulaga(Medan)
 */

use yii\helpers\Html;

$this->title = 'Магазин';
?>
    <div class="mt4 center feedback"><?php echo $this->title; ?></div>

<?php if ($action == 'avatar'): ?>
    <div class="feedback" style="margin-bottom: 4px;">
        <u>
            Покупка аватара
            <?php if (Yii::$app->user->identity->free_avatar >= 1): ?>
                <span style="color:yellow;">бесплатно</span>
            <?php else: ?>
                за <img src="/images/ruby.png" width="16">5000
            <?php endif; ?>
        </u>
    </div>
    <div class="content">
        <div class="blocks">
            <a class="btnl mt4" href="/premium-shop"> В магазин</a>
        </div>
        <div style="text-align: center;">
            <?php foreach ($avatars as $avatar): ?>
                <a href="javascript:void(0);" onclick="buyAvatar(<?php echo $avatar['img']; ?>);"><img width="150"
                                                                                                       height="150"
                                                                                                       alt="" title=""
                                                                                                       src="/images/avatar/user/<?php echo Yii::$app->user->identity->sex; ?>/<?php echo $avatar['img']; ?>.png"></a>
            <?php endforeach; ?>
        </div>
    </div>
    <?php

    $script = <<< JS

	function buyAvatar(avatar)
	{
	
	
	swal({
    title: "Вы уверены, что хотите установить этот аватар?",
    text: "",
    buttons: {
      text: "Да",
      cancel: "Нет"
    }
  }).then(
     function(isConfirm) {
      if(isConfirm){
       $.getJSON('/ajax/avatar-set?id='+avatar, function(data) {
			
			swal(data.title,  '',  data.status);
			setTimeout(function(){
				location.reload();
			}, 1000);
			
		});
      }
    }
  );
		
	
	}
	
	

	
JS;

    $this->registerJs($script, $this::POS_END);
    ?>
<?php elseif ($action == 'premium'): ?>
    <div class="feedback" style="margin-bottom: 4px;">
        <u>
            Покупка премиум аккаунта
        </u>
    </div>
    <div class="feedback">
    <span style="color: orange;"> <img src="/images/ruby.png" alt="$" width="18" height="18">x2<img
                src="/images/cup.png" alt="c" width="18" height="18">x2 в заданиях</span>
    </div>
    <div class="content">
        <div class="blocks">
            <a class="btnl mt4" href="/premium-shop"> В магазин</a>
        </div>
        <div class="content text-center">
            <?php if (Yii::$app->user->identity->vip < time()): ?>
                <span style="color: silver;text-align: center;">У вас обычный аккаунт.</span>
            <?php else: ?>
                <span style="color: yellow;text-align: center;">Премиум аккаунт активен до: <?php echo Html::encode(Yii::$app->formatter->asDate(Yii::$app->user->identity->vip, 'long')) ?></span>
            <?php endif; ?>
        </div>
        <div class="col-xs-12">
            <div class="blocks text-center">
                <a class="btnl center" style="min-width:160px;" href="/premium-shop?action=premium&buy=1">
                    Купить премиум на 1 день за <img src="/images/ruby.png" width="16"><?php echo $cost[1]; ?>
                </a>
            </div>
            <div class="blocks text-center">
                <a class="btnl center" style="min-width:160px;" href="/premium-shop?action=premium&buy=3">
                    Купить премиум на 3 дня за <img src="/images/ruby.png" width="16"><?php echo $cost[3]; ?>
                </a>
            </div>
            <div class="blocks text-center">
                <a class="btnl center" style="min-width:160px;" href="/premium-shop?action=premium&buy=7">
                    Купить премиум на 7 дней за <img src="/images/ruby.png" width="16"><?php echo $cost[7]; ?>
                </a>
            </div>
        </div>
    </div>

<?php else: ?>
    <div class="content">
        <div class="blocks">
            <a class="btnl mt4" href="/premium-shop?action=avatar"> Магазин аватаров</a>
        </div>
        <div class="blocks">
            <a class="btnl mt4" href="/premium-shop?action=premium"> Премиум аккаунт</a>
        </div>
    </div>
<?php endif; ?>